<?php
/**
 * Theme functions and definitions for Hello Child by Digityo.
 *
 * @package HelloChildByDigityo
 
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/

 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_CHILD_DIGITYO_VERSION', '1.0.0' ); // Match version in style.css

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_child_digityo_scripts_styles() {
    wp_enqueue_style(
        'hello-child-digityo-style',
        get_stylesheet_directory_uri() . '/style.css',
        ['hello-elementor'], // Correct parent theme handle
        HELLO_CHILD_DIGITYO_VERSION
    );
}
add_action( 'wp_enqueue_scripts', 'hello_child_digityo_scripts_styles', 20 );